<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\LoanCategory;
use Illuminate\Http\Request;

class LoanCategoryController extends Controller
{
    public function index() {
        return view('admin.loan-categories.index', ['categories' => LoanCategory::all()]);
    }
    public function create() {
        return view('admin.loan-categories.create');
    }
    public function store(Request $request) {

        $request->validate([
            'name' => 'required|unique:loan_categories',
            'min_score' => 'integer|nullable',
            'max_score' => 'integer|nullable'
        ]);


        LoanCategory::create($request->all());
        return redirect()->route('admin.loan-categories.index');
    }
    public function edit(LoanCategory $loanCategory) {
        return view('admin.loan-categories.edit', compact('loanCategory'));
    }
    public function update(Request $request, LoanCategory $loanCategory) {
        $loanCategory->update($request->all());
        return redirect()->route('admin.loan-categories.index');
    }
    public function destroy(LoanCategory $loanCategory) {
        $loanCategory->delete();
        return back();
    }
}
