<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\LoanTenure;
use Illuminate\Http\Request;

class LoanTenureController extends Controller
{
    public function index()
    {
        return view('admin.loan-tenures.index', [
            'tenures' => LoanTenure::all()
        ]);
    }

    public function create()
    {
        return view('admin.loan-tenures.create');
    }

    public function store(Request $request)
    {
        $request->validate(['days' => 'required|integer|unique:loan_tenures']);
        LoanTenure::create($request->only('days'));
        return redirect()->route('admin.loan-tenures.index');
    }

    public function edit(LoanTenure $loanTenure)
    {
    return view('admin.loan-tenures.edit', compact('loanTenure'));
    }

    public function update(Request $request, LoanTenure $loanTenure)
    {
    $request->validate(['days' => 'required|integer|unique:loan_tenures,days,' . $loanTenure->id]);
    $loanTenure->update($request->only('days'));
    return redirect()->route('admin.loan-tenures.index');
    }


    public function destroy(LoanTenure $loanTenure)
    {
        $loanTenure->delete();
        return back();
    }
}

