<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;

class RegisterController extends Controller
{


public function requestMobileOTP(Request $request)
{
    $request->validate([
        'mobile' => 'required|digits_between:10,15'
    ]);
    $otp = '123456'; // static as required
    $user = User::updateOrCreate(
        ['mobile' => $request->mobile],
        [
            'otp' => $otp,
            'otp_expires_at' => now()->addMinutes(5)
        ]
    );
    return response()->json(['message' => 'OTP sent to your mobile.']);
}


public function verifyMobileOTP(Request $request)
{
    $request->validate([
        'mobile' => 'required',
        'otp' => 'required|digits:6'
    ]);
    $user = User::where('mobile', $request->mobile)
        ->where('otp', $request->otp)
        ->where('otp_expires_at', '>', now())
        ->first();
    if (!$user) {
        return response()->json(['message' => 'Invalid or expired OTP'], 422);
    }
    // Clear OTP
    $user->update([
        'otp' => null,
        'otp_expires_at' => null,
        'mobile_verified_at' => now()
    ]);
    // Issue Sanctum token
    $token = $user->createToken('API Token')->plainTextToken;
    return response()->json([
        'token' => $token,
        'token_type' => 'Bearer'
    ]);
}


public function requestEmailOTP(Request $request)
{
    $request->validate([
        'mobile' => 'required',
        'email' => 'required|email'
    ]);
    $user = User::where('mobile', $request->mobile)->first();
    if (!$user) {
        return response()->json(['message' => 'Mobile number not found'], 404);
    }

    if (!$user->email) {
        // First time email registration for this mobile
        $user->email = $request->email;
        $user->save();
    } elseif ($user->email !== $request->email) {
        // The email tried does not match what's already registered
        return response()->json(['message' => 'Email does not match this mobile'], 422);
    }

    $emailOtp = rand(100000, 999999);
    $user->update([
        'email_otp' => $emailOtp,
        'email_otp_expires_at' => now()->addMinutes(5)
    ]);
    Mail::raw("Your Email OTP is: $emailOtp", function ($message) use ($request) {
        $message->to($request->email)->subject('Your Email OTP Code');
    });
    return response()->json(['message' => 'Email OTP sent.']);
}



    public function verifyEmailOTP(Request $request)
{


    $request->validate([
        'mobile' => 'required',
        'email_otp' => 'required'
    ]);



    $user = User::where('mobile', $request->mobile)
        ->where('email_otp', $request->email_otp)
        ->where('email_otp_expires_at', '>', now())
        ->first();
    if (!$user) {
        return response()->json(['message' => 'Invalid or expired email OTP'], 422);
    }
    // Clear email OTP and mark email as verified
    $user->update([
        'email_otp' => null,
        'email_otp_expires_at' => null,
        'email_verified_at' => now()
    ]);
    return response()->json(['message' => 'Email verified.']);
}




public function setPin(Request $request) {
    $request->validate([
        'security_pin' => 'required|digits:4', // or digits:6
    ]);
    $user = $request->user();
    $user->security_pin = Hash::make($request->security_pin);
    $user->save();
    return response()->json(['message' => 'Security PIN set successfully.']);
}


public function verifyPin(Request $request) {
    $request->validate([
        'security_pin' => 'required|digits:4',
    ]);
    $user = $request->user();
    if (!Hash::check($request->security_pin, $user->security_pin)) {
        return response()->json(['message' => 'Invalid security PIN.'], 401);
    }
    return response()->json(['message' => 'PIN verified, access granted.']);
}




}
