<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\LoanCategory;


class LoanProduct extends Model
{
    use HasFactory;

    protected $fillable = [
    'loan_category_id', 'amount', 'interest_percent',
    'processing_fee_percent', 'processing_fee_per_day',
    'processing_offer_percent', 'protection_fee_percent',
    'tenure_ids'
 ];

 public function category()
{
    return $this->belongsTo(LoanCategory::class, 'loan_category_id', 'id');
}


    protected $casts = [
        'tenure_ids' => 'array',
    ];



}
