<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('loan_products', function (Blueprint $table) {
            $table->id();
            $table->foreignId('loan_category_id')->constrained()->onDelete('cascade');
            $table->unsignedInteger('amount');
            $table->decimal('interest_percent', 5, 2);
            $table->decimal('processing_fee_percent', 5, 2);
            $table->decimal('processing_fee_per_day', 8, 2);
            $table->decimal('processing_offer_percent', 5, 2)->nullable();
            $table->decimal('protection_fee_percent', 5, 2)->default(2.00);
            $table->json('tenure_ids');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('loan_products');
    }
};
