@extends('layouts.admin')

@section('content')
<h1>Loan Categories</h1>
<a href="{{ route('admin.loan-categories.create') }}">+ Add New Category</a>

<table>
    <thead>
        <tr>
            <th>No</th>
            <th>Name</th>
            <th>Score Range</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        @foreach($categories as $category)
        <tr>
            <td>{{ $loop->iteration }}</td>
            <td>{{ $category->name }}</td>
            <td>{{ $category->min_score }} - {{ $category->max_score }}</td>
            <td>
                <a href="{{ route('admin.loan-categories.edit', $category) }}">Edit</a>
                <form action="{{ route('admin.loan-categories.destroy', $category) }}" method="POST" style="display:inline;">
                    @csrf @method('DELETE')
                    <button onclick="return confirm('Delete?')" type="submit">Delete</button>
                </form>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
@endsection
