@extends('layouts.admin')

@section('content')
<h1>Edit Loan Product</h1>

<form method="POST" action="{{ route('admin.loan-products.update', $loanProduct->id) }}">
    @csrf
    @method('PUT')

    <label>Loan Category</label>
    <select name="loan_category_id" required>
        @foreach($categories as $cat)
            <option value="{{ $cat->id }}" @selected($loanProduct->loan_category_id == $cat->id)>
                {{ $cat->name }}
            </option>
        @endforeach
    </select><br>

    <label>Amount (₹)</label>
    <input name="amount" type="number" value="{{ old('amount', $loanProduct->amount) }}" required><br>

    <label>Interest %</label>
    <input name="interest_percent" type="number" step="0.01" value="{{ old('interest_percent', $loanProduct->interest_percent) }}" required><br>

    <label>Available Tenures</label>
    <select name="tenure_ids[]" multiple required>
        @foreach($tenures as $tenure)
            <option value="{{ $tenure->id }}" @selected(in_array($tenure->id, old('tenure_ids', $loanProduct->tenure_ids ?? [])))>
                {{ $tenure->days }} days
            </option>
        @endforeach
    </select><br>

    <label>Processing Fee %</label>
    <input name="processing_fee_percent" type="number" step="0.01" value="{{ old('processing_fee_percent', $loanProduct->processing_fee_percent) }}" required><br>

    <label>Processing Fee ₹/day</label>
    <input name="processing_fee_per_day" type="number" step="0.01" value="{{ old('processing_fee_per_day', $loanProduct->processing_fee_per_day) }}" required><br>

    <label>Processing Offer %</label>
    <input name="processing_offer_percent" type="number" step="0.01" value="{{ old('processing_offer_percent', $loanProduct->processing_offer_percent) }}"><br>

    <label>Protection Fee %</label>
    <input name="protection_fee_percent" type="number" step="0.01" value="{{ old('protection_fee_percent', $loanProduct->protection_fee_percent ?? 2.00) }}"><br>

    <button type="submit">Update</button>
</form>
@endsection
