@extends('layouts.admin')

@section('content')
<h1>Loan Products</h1>
<a href="{{ route('admin.loan-products.create') }}">+ Add New</a>
<table border="1" cellpadding="5">
    <thead>
        <tr>
            <th>Category</th>
            <th>Amount</th>
            <th>Interest % (Per Month)</th>
            <th>Tenures</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        @foreach($products as $product)


        <tr>
            <td>{{ $product->category->name ?? '-' }}</td>
            <td>{{ $product->amount }}</td>
            <td>{{ $product->interest_percent }}</td>
            <td>
                @foreach($product->tenure_ids as $tid)
                    {{ $tenures->firstWhere('id', $tid)->days ?? '?' }} days
                    @if (!$loop->last), @endif
                @endforeach
            </td>
            <td>
                <a href="{{ route('admin.loan-products.edit', $product->id) }}">Edit</a> |
                <form method="POST" action="{{ route('admin.loan-products.destroy', $product->id) }}" style="display:inline">
                    @csrf @method('DELETE')
                    <button onclick="return confirm('Delete this product?')" type="submit">Delete</button>
                </form>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
@endsection
