@extends('layouts.admin')

@section('content')
<h1>Loan Tenures</h1>
<a href="{{ route('admin.loan-tenures.create') }}">+ Add New</a>

<table border="1" cellpadding="5">
    <thead>
        <tr>
            <th>ID</th>
            <th>Days</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        @foreach($tenures as $tenure)
        <tr>
            <td>{{ $tenure->id }}</td>
            <td>{{ $tenure->days }} days</td>
            <td>
                <form method="POST" action="{{ route('admin.loan-tenures.destroy', $tenure->id) }}" style="display:inline;">
                    @csrf @method('DELETE')
                    <button onclick="return confirm('Delete this tenure?')" type="submit">Delete</button>
                </form>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
@endsection
