<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Panel - @yield('title', 'Dashboard')</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body { font-family: sans-serif; padding: 20px; background: #f7f7f7; }
        header { background: #343a40; color: white; padding: 10px 20px; }
        nav a { color: white; margin-right: 15px; text-decoration: none; }
        main { background: white; padding: 20px; margin-top: 20px; border-radius: 6px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        table, th, td { border: 1px solid #ccc; }
        th, td { padding: 10px; text-align: left; }
        a.button { padding: 5px 10px; background: #007bff; color: white; border-radius: 4px; text-decoration: none; }
        form button { background: #dc3545; color: white; border: none; padding: 5px 10px; border-radius: 4px; }
    </style>
</head>
<body>

<header>
    <h2>Admin Panel</h2>
    <nav>
        <a href="{{ route('admin.loan-categories.index') }}">Loan Categories</a>
        <a href="{{ route('admin.loan-products.index') }}">Loan Products</a>
        <a href="{{ route('admin.dashboard') }}">Dashboard</a>
        <form action="{{ route('admin.logout') }}" method="POST" style="display:inline;">
            @csrf
            <button type="submit">Logout</button>
        </form>
    </nav>
</header>

<main>
    @yield('content')
</main>

</body>
</html>
