<?php
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\LoanProductController;
use App\Http\Controllers\KycController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

// Basic authenticated user info
Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// Registration and authentication steps (public)
Route::post('/auth/request-mobile-otp', [RegisterController::class, 'requestMobileOTP']);
Route::post('/auth/verify-mobile-otp', [RegisterController::class, 'verifyMobileOTP']);

// If you add PIN verification:
Route::post('/auth/verify-pin', [RegisterController::class, 'verifySecurityPin']);

// Optionally, login using mobile + OTP flow (if you split login process)
Route::post('/auth/login/mobile', [LoginController::class, 'loginWithMobileOTP']);
// Optionally, login using email+PIN or password if supported
Route::post('/auth/login/email', [LoginController::class, 'loginWithEmailOTP']);

Route::middleware('auth:sanctum')->group(function () {

    Route::post('/auth/request-email-otp', [RegisterController::class, 'requestEmailOTP']);
    Route::post('/auth/verify-email-otp', [RegisterController::class, 'verifyEmailOTP']);

    Route::post('/auth/set-pin', [RegisterController::class, 'setPin']);
    Route::post('/auth/verify-pin', [RegisterController::class, 'verifyPin']);



    Route::get('/me', [LoginController::class, 'me']);
    Route::get('/loans', [LoanProductController::class, 'listLoans']);
    Route::get('/loans/{id}', [LoanProductController::class, 'viewLoan']);
    Route::get('/loans/{id}/interest-details', [LoanProductController::class, 'loanInterestDetails']);

    
    Route::post('/verify-pan', [KycController::class, 'verifyPan']);
    Route::post('/aadhaar/init', [KycController::class, 'initDigiLocker']);
    Route::get('/aadhaar/download/{client_id}', [KycController::class, 'downloadAadhaar']);

    Route::post('/logout', [LoginController::class, 'logout']);
});
