<?php

use App\Http\Controllers\Admin\AdminAuthController;
use App\Http\Controllers\Admin\LoanCategoryController;
use App\Http\Controllers\Admin\LoanProductController;
use App\Http\Controllers\Admin\LoanTenureController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::prefix('admin')->group(function () {
    Route::get('/login', [AdminAuthController::class, 'showLoginForm'])->name('admin.login');
    Route::post('/login', [AdminAuthController::class, 'login'])->name('admin.login.submit');
    Route::post('/logout', [AdminAuthController::class, 'logout'])->name('admin.logout');

    Route::middleware(['auth', 'admin'])->group(function () {
        Route::get('/dashboard', fn () => view('admin.dashboard'))->name('admin.dashboard');
        Route::get('loan-categories', [LoanCategoryController::class, 'index'])->name('admin.loan-categories.index');
        Route::get('loan-categories/create', [LoanCategoryController::class, 'create'])->name('admin.loan-categories.create');
        Route::post('loan-categories', [LoanCategoryController::class, 'store'])->name('admin.loan-categories.store');
        Route::get('loan-categories/{loanCategory}/edit', [LoanCategoryController::class, 'edit'])->name('admin.loan-categories.edit');
        Route::put('loan-categories/{loanCategory}', [LoanCategoryController::class, 'update'])->name('admin.loan-categories.update');
        Route::delete('loan-categories/{loanCategory}', [LoanCategoryController::class, 'destroy'])->name('admin.loan-categories.destroy');

        Route::get('loan-products', [LoanProductController::class, 'index'])->name('admin.loan-products.index');
        Route::get('loan-products/create', [LoanProductController::class, 'create'])->name('admin.loan-products.create');
        Route::post('loan-products', [LoanProductController::class, 'store'])->name('admin.loan-products.store');
        Route::get('loan-products/{loanProduct}/edit', [LoanProductController::class, 'edit'])->name('admin.loan-products.edit');
        Route::put('loan-products/{loanProduct}', [LoanProductController::class, 'update'])->name('admin.loan-products.update');
        Route::delete('loan-products/{loanProduct}', [LoanProductController::class, 'destroy'])->name('admin.loan-products.destroy');


        Route::get('loan-tenures', [LoanTenureController::class, 'index'])->name('admin.loan-tenures.index');
        Route::get('loan-tenures/create', [LoanTenureController::class, 'create'])->name('admin.loan-tenures.create');
        Route::post('loan-tenures', [LoanTenureController::class, 'store'])->name('admin.loan-tenures.store');
        Route::delete('loan-tenures/{loanTenure}', [LoanTenureController::class, 'destroy'])->name('admin.loan-tenures.destroy');
    });
});
