<?php $__env->startSection('content'); ?>
<h1>Edit Loan Product</h1>

<form method="POST" action="<?php echo e(route('admin.loan-products.update', $loanProduct->id)); ?>">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?>

    <label>Loan Category</label>
    <select name="loan_category_id" required>
        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($cat->id); ?>" <?php if($loanProduct->loan_category_id == $cat->id): echo 'selected'; endif; ?>>
                <?php echo e($cat->name); ?>

            </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select><br>

    <label>Amount (₹)</label>
    <input name="amount" type="number" value="<?php echo e(old('amount', $loanProduct->amount)); ?>" required><br>

    <label>Interest %</label>
    <input name="interest_percent" type="number" step="0.01" value="<?php echo e(old('interest_percent', $loanProduct->interest_percent)); ?>" required><br>

    <label>Available Tenures</label>
    <select name="tenure_ids[]" multiple required>
        <?php $__currentLoopData = $tenures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tenure): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($tenure->id); ?>" <?php if(in_array($tenure->id, old('tenure_ids', $loanProduct->tenure_ids ?? []))): echo 'selected'; endif; ?>>
                <?php echo e($tenure->days); ?> days
            </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select><br>

    <label>Processing Fee %</label>
    <input name="processing_fee_percent" type="number" step="0.01" value="<?php echo e(old('processing_fee_percent', $loanProduct->processing_fee_percent)); ?>" required><br>

    <label>Processing Fee ₹/day</label>
    <input name="processing_fee_per_day" type="number" step="0.01" value="<?php echo e(old('processing_fee_per_day', $loanProduct->processing_fee_per_day)); ?>" required><br>

    <label>Processing Offer %</label>
    <input name="processing_offer_percent" type="number" step="0.01" value="<?php echo e(old('processing_offer_percent', $loanProduct->processing_offer_percent)); ?>"><br>

    <label>Protection Fee %</label>
    <input name="protection_fee_percent" type="number" step="0.01" value="<?php echo e(old('protection_fee_percent', $loanProduct->protection_fee_percent ?? 2.00)); ?>"><br>

    <button type="submit">Update</button>
</form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/icash/public_html/backend/resources/views/admin/loan-products/edit.blade.php ENDPATH**/ ?>