<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Panel - <?php echo $__env->yieldContent('title', 'Dashboard'); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body { font-family: sans-serif; padding: 20px; background: #f7f7f7; }
        header { background: #343a40; color: white; padding: 10px 20px; }
        nav a { color: white; margin-right: 15px; text-decoration: none; }
        main { background: white; padding: 20px; margin-top: 20px; border-radius: 6px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        table, th, td { border: 1px solid #ccc; }
        th, td { padding: 10px; text-align: left; }
        a.button { padding: 5px 10px; background: #007bff; color: white; border-radius: 4px; text-decoration: none; }
        form button { background: #dc3545; color: white; border: none; padding: 5px 10px; border-radius: 4px; }
    </style>
</head>
<body>

<header>
    <h2>Admin Panel</h2>
    <nav>
        <a href="<?php echo e(route('admin.loan-categories.index')); ?>">Loan Categories</a>
        <a href="<?php echo e(route('admin.loan-products.index')); ?>">Loan Products</a>
        <a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a>
        <form action="<?php echo e(route('admin.logout')); ?>" method="POST" style="display:inline;">
            <?php echo csrf_field(); ?>
            <button type="submit">Logout</button>
        </form>
    </nav>
</header>

<main>
    <?php echo $__env->yieldContent('content'); ?>
</main>

</body>
</html>
<?php /**PATH /home1/icash/public_html/backend/resources/views/layouts/admin.blade.php ENDPATH**/ ?>